/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.world.inventory.data;

import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import java.util.Locale;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.Rotations;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public final class PosePartMutator {
    public static final PosePartMutator HEAD = new PosePartMutator("head", ArmorStandPose::getHeadPose, ArmorStandPose::withHeadPose, PosePartAxisRange.range(-60.0, 60.0), PosePartAxisRange.range(-60.0, 60.0), PosePartAxisRange.range(-120.0, 120.0));
    public static final PosePartMutator BODY = new PosePartMutator("body", ArmorStandPose::getBodyPose, ArmorStandPose::withBodyPose, PosePartAxisRange.range(-30.0, 30.0), PosePartAxisRange.range(-30.0, 30.0), PosePartAxisRange.range(-120.0, 120.0));
    public static final PosePartMutator RIGHT_ARM = new PosePartMutator("rightArm", ArmorStandPose::getRightArmPose, ArmorStandPose::withRightArmPose, PosePartAxisRange.range(-180.0, 0.0), PosePartAxisRange.range(-90.0, 45.0), PosePartAxisRange.range(-120.0, 120.0));
    public static final PosePartMutator LEFT_ARM = new PosePartMutator("leftArm", ArmorStandPose::getLeftArmPose, ArmorStandPose::withLeftArmPose, PosePartAxisRange.range(-180.0, 0.0), PosePartAxisRange.range(-45.0, 90.0), PosePartAxisRange.range(-120.0, 120.0));
    public static final PosePartMutator RIGHT_LEG = new PosePartMutator("rightLeg", ArmorStandPose::getRightLegPose, ArmorStandPose::withRightLegPose, PosePartAxisRange.range(-120.0, 120.0), PosePartAxisRange.range(-90.0, 0.0), PosePartAxisRange.range(-120.0, 120.0));
    public static final PosePartMutator LEFT_LEG = new PosePartMutator("leftLeg", ArmorStandPose::getLeftLegPose, ArmorStandPose::withLeftLegPose, PosePartAxisRange.range(-120.0, 120.0), PosePartAxisRange.range(0.0, 90.0), PosePartAxisRange.range(-120.0, 120.0));
    public static final String AXIS_X_TRANSLATION_KEY = "statues.screen.rotations.x";
    public static final String AXIS_Y_TRANSLATION_KEY = "statues.screen.rotations.y";
    public static final String AXIS_Z_TRANSLATION_KEY = "statues.screen.rotations.z";
    private final String name;
    private final Function<ArmorStandPose, Rotations> getRotations;
    private final BiFunction<ArmorStandPose, Rotations, ArmorStandPose> setRotations;
    private final PosePartAxisRange[] axisRanges;
    private final Direction.Axis[] axisOrder;
    private final byte invertedIndices;

    public PosePartMutator(String name, Function<ArmorStandPose, Rotations> getRotations, BiFunction<ArmorStandPose, Rotations, ArmorStandPose> setRotations, PosePartAxisRange rangeX, PosePartAxisRange rangeY, PosePartAxisRange rangeZ) {
        this(name, getRotations, setRotations, rangeX, rangeY, rangeZ, new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Y, Direction.Axis.Z}, Direction.Axis.Y);
    }

    public PosePartMutator(String name, Function<ArmorStandPose, Rotations> getRotations, BiFunction<ArmorStandPose, Rotations, ArmorStandPose> setRotations, PosePartAxisRange rangeX, PosePartAxisRange rangeY, PosePartAxisRange rangeZ, Direction.Axis[] axisOrder, Direction.Axis ... invertedAxes) {
        this.name = name;
        this.getRotations = getRotations;
        this.setRotations = setRotations;
        this.axisRanges = new PosePartAxisRange[]{rangeX, rangeY, rangeZ};
        this.axisOrder = axisOrder;
        this.invertedIndices = PosePartMutator.computeInvertedIndices(invertedAxes);
    }

    private static byte computeInvertedIndices(Direction.Axis[] invertedAxes) {
        byte invertedIndices = 0;
        for (Direction.Axis axis : invertedAxes) {
            invertedIndices = (byte)(invertedIndices | 1 << axis.ordinal());
        }
        return invertedIndices;
    }

    public String toString() {
        return this.name.toUpperCase(Locale.ROOT);
    }

    public String getTranslationKey() {
        return "statues.screen.rotations.pose." + this.name;
    }

    public Component getAxisComponent(ArmorStandPose pose, int index) {
        double value = ArmorStandPose.snapValue(this.getRotationsAtAxis(index, pose), 0.125);
        return Component.m_237110_((String)this.getAxisTranslationKey(this.getAxisAt(index)), (Object[])new Object[]{ArmorStandPose.ROTATION_FORMAT.format(value)});
    }

    private String getAxisTranslationKey(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> AXIS_X_TRANSLATION_KEY;
            case Direction.Axis.Y -> AXIS_Y_TRANSLATION_KEY;
            case Direction.Axis.Z -> AXIS_Z_TRANSLATION_KEY;
        };
    }

    public double getRotationsAtAxis(int index, ArmorStandPose pose) {
        return this.getRotationsAtAxis(index, this.getRotations.apply(pose));
    }

    private double getRotationsAtAxis(int index, Rotations rotations) {
        return switch (this.getAxisAt(index)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> this.invertAtAxis(Direction.Axis.X, rotations.m_175532_());
            case Direction.Axis.Y -> this.invertAtAxis(Direction.Axis.Y, rotations.m_175533_());
            case Direction.Axis.Z -> this.invertAtAxis(Direction.Axis.Z, rotations.m_175534_());
        };
    }

    public double getNormalizedRotationsAtAxis(int index, ArmorStandPose pose, boolean clampRotations) {
        return this.getNormalizedRotationsAtAxis(index, this.getRotations.apply(pose), clampRotations);
    }

    private double getNormalizedRotationsAtAxis(int index, Rotations rotations, boolean clampRotations) {
        return switch (this.getAxisAt(index)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> (float)this.getAxisRangeAtAxis(Direction.Axis.X, clampRotations).normalize(this.invertAtAxis(Direction.Axis.X, rotations.m_175532_()));
            case Direction.Axis.Y -> (float)this.getAxisRangeAtAxis(Direction.Axis.Y, clampRotations).normalize(this.invertAtAxis(Direction.Axis.Y, rotations.m_175533_()));
            case Direction.Axis.Z -> (float)this.getAxisRangeAtAxis(Direction.Axis.Z, clampRotations).normalize(this.invertAtAxis(Direction.Axis.Z, rotations.m_175534_()));
        };
    }

    private float invertAtAxis(Direction.Axis axis, float value) {
        return (this.invertedIndices >> axis.ordinal() & 1) == 1 ? value * -1.0f : value;
    }

    public ArmorStandPose setRotationsAtAxis(int index, ArmorStandPose pose, double newValue, boolean clampRotations) {
        return this.setRotations.apply(pose, this.setRotationsAtAxis(index, this.getRotations.apply(pose), (float)this.getAxisRangeAtAxis(index, clampRotations).expand(newValue)));
    }

    private PosePartAxisRange getAxisRangeAtAxis(int index, boolean clampRotations) {
        return this.getAxisRangeAtAxis(this.getAxisAt(index), clampRotations);
    }

    private PosePartAxisRange getAxisRangeAtAxis(Direction.Axis axis, boolean clampRotations) {
        return clampRotations ? this.axisRanges[axis.ordinal()] : PosePartAxisRange.fullRange();
    }

    private Rotations setRotationsAtAxis(int index, Rotations rotations, float newValue) {
        return switch (this.getAxisAt(index)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Rotations(this.invertAtAxis(Direction.Axis.X, newValue), rotations.m_123157_(), rotations.m_123158_());
            case Direction.Axis.Y -> new Rotations(rotations.m_123156_(), this.invertAtAxis(Direction.Axis.Y, newValue), rotations.m_123158_());
            case Direction.Axis.Z -> new Rotations(rotations.m_123156_(), rotations.m_123157_(), this.invertAtAxis(Direction.Axis.Z, newValue));
        };
    }

    public Direction.Axis getAxisAt(int index) {
        return this.axisOrder[index];
    }

    Rotations randomRotations(boolean clampRotations) {
        Rotations rotations = new Rotations((float)this.getAxisRangeAtAxis(Direction.Axis.X, clampRotations).random(), (float)this.getAxisRangeAtAxis(Direction.Axis.Y, clampRotations).random(), (float)this.getAxisRangeAtAxis(Direction.Axis.Z, clampRotations).random());
        return clampRotations ? this.setRotationsAtAxis(2, rotations, 0.0f) : rotations;
    }

    public record PosePartAxisRange(double min, double max) {
        public static final double MIN_VALUE = -180.0;
        public static final double MAX_VALUE = 180.0;
        private static final Random RANDOM = new Random();

        public PosePartAxisRange {
            if (min >= max) {
                throw new IllegalArgumentException("Min must be smaller than max: %s >= %s".formatted(min, max));
            }
            if (Mth.m_14008_((double)min, (double)-180.0, (double)180.0) != min) {
                throw new IllegalArgumentException("Min out of bounds, must be between %s and %s, was %s".formatted(-180.0, 180.0, min));
            }
            if (Mth.m_14008_((double)max, (double)-180.0, (double)180.0) != max) {
                throw new IllegalArgumentException("Max out of bounds, must be between %s and %s, was %s".formatted(-180.0, 180.0, max));
            }
        }

        public static PosePartAxisRange fullRange() {
            return PosePartAxisRange.range(-180.0, 180.0);
        }

        public static PosePartAxisRange range(double min, double max) {
            return new PosePartAxisRange(min, max);
        }

        public double normalize(double expandedValue) {
            return (this.clamp(expandedValue) - this.min) / this.range();
        }

        public double expand(double normalizedValue) {
            return normalizedValue * this.range() + this.min;
        }

        public double clamp(double value) {
            return Mth.m_14008_((double)value, (double)this.min, (double)this.max);
        }

        public double random() {
            return RANDOM.nextDouble(this.range()) + this.min;
        }

        public double range() {
            return this.max - this.min;
        }
    }
}

